//Dynare set-up:  NK Model with costs of adjusting investment, habit wage and price stickiness, and indexing
//With SW Preferences 
//Solve for only H in the external steady state. 
//Note H can be an index and is not a proportion of available time as in JR preferences 
// 
//(c) CIMS Univeristy of Surrey
//The Science and  Art of DSGE Modelling: Construction, Calibration, Estimation and Policy
//////////////////////////////////////////////////////////////////////////////////////////////////
//This is a free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.  See <http://www.gnu.org/licenses/> for more information.
//////////////////////////////////////////////////////////////////////////////////////////////////

%
%when changing these options first clear the workspace by typing clear all in matlab
%


@#define form_of_habits=0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Choose the form of habits%%
%%external=1; else internal%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@#define wagesticky = 1
%
% wagesticky = 1 gives sticky wages
% wagesticky = 0 gives flexi wages
%
%
@#define form_of_indexing= 1
%
%form_of_indexing= 1 gives indexing of wages and prices in the steady state (as in SW07)
%form_of_indexing= 0 gives no indexing of wages and prices in the steady state
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF ENDOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
var U UC UH R LAMBDA RK C  W H Hd Y YW PWP K  I  
KYW IY CY S Sdash Q X Rn ER  PIE MC 
JJp  Jp  PIEtilde Deltap PO 
Wh Invmarkup Jw JJw PIEw  Deltaw WO PIEwptilde PIEwtilde 
A G MCS  MRSS MPS RPS IS  epsAtrendstate
spread  g bettag  lam    N CEequiv Omega;

 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF EXOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
varexo epsA epsG epsMC epsMPS  epsIS epsAtrend epsMRSS epsRPS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parameters gy  alp  zzeta betta delta  sigma_c  sigma_s rhoA rhoG phiX
xip xiw rho_r theta_pie theta_y theta_dy 
rhoMC rhoMRSS rhoMPS rhoRPS  rhoIS 
chi gammap gammaw 
A_bar H_bar PIE_bar  g_bar  RPS_bar  cy habit 
index wage muw spreadtarg bettag_bar h   sigma_l; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%CALIBRATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
PIE_bar=1.01;
%H as a index of hours supplied by households solved in in the steady state
g_bar=0.005;
spreadtarg=0.0;


@#if  form_of_indexing==1
%indexing of wages and prices in the steady state (as in SW07)
% 
index=1;
@#else
%indexing of wages and prices in the steady state 
index=0;
@#endif

gammap=0.25;
gammaw=0.5; 
chi=0.7;
phiX=2.0;
cy=0.6;
gy=0.18;
alp=0.67;
zzeta=7.0;
betta=0.99;
delta=0.0250;
sigma_c=1.5;
phiX=2.0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Set RPS in ss to hit spread target
%
bettag_bar=betta*(1+g_bar)^(-sigma_c);
RPS_bar=1.0/(1-spreadtarg*bettag_bar);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set sigma_l = approx Frisch parameter = SW elasticity =2 for prior
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sigma_l = 2;


%




%
%Choice of Units
%
A_bar=1;
%
%shock persistence
%
rhoA=0.75;
rhoG=0.75;
rhoMC=0.75;
rhoMRSS=0.75;
rhoMPS=0.75;
rhoRPS=0.75;
rhoIS=0.75;


xip=0.75; //high stickyness
xiw=0.75; //high stickyness
%
%Monetary Policy Rule Feedback
%
rho_r=0.7;
theta_pie=1.5;
theta_y=0.3;
theta_dy=0.3;
%
%scale sd of shocks; 1 for irfs and order 1; 0.01 for second moments and order 2  
%
sigma_s=0.01;
sigma_s=1.0;

@#if  form_of_habits==1
%
%external habit
%
habit=1;
@#else  
%internal habit
%
habit=0;

@#endif

@#if wagesticky >0
wage=1;
 xiw=0.75;
muw=3;
@#else
wage=0;
xiw=0;
muw=1000;
@#endif

% ----------------------------
% *** DSGE-Model-equations ***
% ----------------------------
model;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%For Comparison with FF models define a net value N=0
%
N=0.00001*Y;
%%%%%%%%%%%%%%%%%%%%%%%%
%Growth in A
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
log(1+g)=log(1+g_bar)+epsAtrend;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Household Problem with SW Preferences
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


bettag=betta*(1+g)^(-sigma_c);

%%%%%%%%%%%%%%%%%%%%%%%%%
%%Single period utility%%
%%%%%%%%%%%%%%%%%%%%%%%%%
U=((C-chi*C(-1)/(1+g))^(1-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l)) -1)/(1-sigma_c);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Consumption Equivalent (CE) Calculation eqn 7
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
CEequiv=(1.01*(C-chi*C(-1)/(1+g))^(1-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l))-1)/(1-sigma_c)-U+(1+g(+1))*bettag(+1)*CEequiv(+1);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Intertemporal welfare
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%First define a state=exog shock because dynare cannot have a lead of lag of an exog shock
epsAtrendstate=epsAtrend;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Omega=U+betta*(1+g_bar)^(1-sigma_c)*exp((1-sigma_c)*epsAtrendstate(+1))*Omega(+1);
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Marginal utility of consumption%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
UC=(C-chi*C(-1)/(1+g))^(-sigma_c)*exp((sigma_c-1)*H^(1+sigma_l)/(1+sigma_l));
UH=-UC*H^(sigma_l)*(C-chi*C(-1)/(1+g));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Euler equation with Risk Premium Shock%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lam=bettag(+1)*R(+1)*RPS*lam(+1);
%
@#if  form_of_habits==1
%
%external habit
%
lam=UC;
@#else  
%internal habit 
lam=UC-bettag(+1)*chi*UC(+1);
%
@#endif

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Labour supply foc. 
%Note Wh=W_{h,t}/P_t is the real wage rate
%for homogeneous household labour before differentiation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-UH/lam=Wh;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%Fisher Equation
%
R=Rn(-1)/PIE;
ER=Rn/PIE(+1);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Wholesale and retail sector relation%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y=YW/Deltap;
Hd=H/Deltaw;


%%%%%%%%%%%%%%%%%%%%%%%
%%Production Function%%
%%%%%%%%%%%%%%%%%%%%%%%
%
%Note: Capital stock is end-of-period
%
YW=((A*Hd)^alp)*(K(-1)/(1+g))^(1-alp);
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Household Investment FOC and Wholesale firms Labour demand FOC%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
RK=((1-alp)*PWP*YW/(K(-1)/(1+g))+(1-delta)*Q)/Q(-1);
%
%where Tobin's Q is given by
%
%Stochastic Discount Factor lagged
%
LAMBDA=bettag*lam/lam(-1);
%
IS*Q*(1-S-X*Sdash)+LAMBDA(+1)*Q(+1)*IS(+1)*Sdash(+1)*X(+1)^2=1;
%
PWP*(alp*YW)/Hd=W;
%%%%%%%%%%%%%%%%%%%%%%%%%
%%Capital law of motion%% 
%%%%%%%%%%%%%%%%%%%%%%%%%
%
K=(1-S)*I*IS+(1-delta)*K(-1)/(1+g);
%
%where
%
X=I*(1+g)/I(-1);
S=phiX*(X-1-g)^2;
Sdash=2*phiX*(X-1-g);
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Arbbitrage
%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
LAMBDA(+1)*RK(+1)=1;
%
%Banking Model with friction replaces this arbitrage condition 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
spread=RK-R;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Output Market Equilibrium%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y=C+G+I;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Price Inflation Dynamics and Price Dispersion%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
JJp-xip*LAMBDA(+1)*PIEtilde(+1)^(zzeta-1)*JJp(+1)*(1+g(+1))=Y;
Jp-xip*LAMBDA(+1)*PIEtilde(+1)^zzeta*Jp(+1)*(1+g(+1))=(1/(1-1/zzeta))*Y*MC*MCS;
@# if form_of_indexing ==1
PIEtilde=(PIE/PIE(-1)^gammap)/STEADY_STATE(PIE)^(1-gammap);// Complete indexing in ss
@#else
PIEtilde=(PIE/PIE(-1)^gammap);// No indexing in ss
@#endif
PO=Jp/JJp;
1=xip*PIEtilde^(zzeta-1)+(1-xip)*(PO)^(1-zzeta);
Deltap=xip*(PIEtilde^zzeta)*Deltap(-1)+(1-xip)*PO^(-zzeta);
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Wage Inflation Dynamics and Wage Dispersion%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@#if wagesticky > 0
PIEw=(1+g)*PIE*W/W(-1);
@# if form_of_indexing ==1
PIEwtilde=PIEw/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
@#else
PIEwtilde=PIEw/PIE(-1)^gammaw;//no indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw;//no indexing in ss;
@#endif
JJw-xiw*LAMBDA(+1)*PIEwtilde(+1)^(muw)/PIEwptilde(+1)*JJw(+1)=Hd;
Jw-xiw*LAMBDA(+1)*PIEwtilde(+1)^muw*Jw(+1)*(1+g(+1))=(1/(1-1/muw))*Hd*Wh*MRSS;
%
%

WO=Jw/(W*JJw);
1=xiw*(PIEw*PIEwptilde/PIE)^(muw-1)+(1-xiw)*WO^(1-muw);
Deltaw=xiw*(PIEwtilde^muw)*Deltaw(-1)+(1-xiw)*WO^(-muw);
@#else
PIEw=(1+g)*PIE*W/W(-1);
JJw=Hd;
Jw=Hd*Wh*MRSS;
PIEwtilde=PIEw/PIE(-1)^gammaw;//No indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw;//No indexing in ss;
W=Wh*MRSS;
Deltaw=1;
WO=Jw/(W*JJw);
@#endif

Invmarkup=Wh/W;


%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Taylor rule - implementable rule (relative to ss)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
log(Rn/STEADY_STATE(Rn))=rho_r*log(Rn(-1)/STEADY_STATE(Rn))+(1-rho_r)*(theta_pie*log(PIE/STEADY_STATE(PIE))
+theta_y*log(Y/STEADY_STATE(Y))+theta_dy*log(Y/Y(-1)))+log(MPS);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Mark-up Monopolistic pricing%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

MC=PWP;

%%%%%%%%%%%%%%%%%%%
%%Shock processes%%
%%%%%%%%%%%%%%%%%%%
log(A)-log(STEADY_STATE(A))=rhoA*(log(A(-1))-log(STEADY_STATE(A)))+epsA;
log(G)-log(STEADY_STATE(G))=rhoG*(log(G(-1))-log(STEADY_STATE(G)))+epsG;
log(MCS)-log(STEADY_STATE(MCS))=rhoMC*(log(MCS(-1))-log(STEADY_STATE(MCS)))+epsMC;
log(MRSS)-log(STEADY_STATE(MRSS))=rhoMRSS*(log(MRSS(-1))-log(STEADY_STATE(MRSS)))+epsMRSS;
log(IS)-log(STEADY_STATE(IS))=rhoIS*(log(IS(-1))-log(STEADY_STATE(IS)))+epsIS;
log(MPS)-log(STEADY_STATE(MPS))=rhoMPS*(log(MPS(-1))-log(STEADY_STATE(MPS)))+epsMPS;
log(RPS)-log(STEADY_STATE(RPS))=rhoRPS*(log(RPS(-1))-log(STEADY_STATE(RPS)))+epsRPS;




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Ratios used in steady state
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
KYW=K/YW;
IY=I/Y;
CY=C/Y;

end;

steady;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%SPECIFICATION OF SHOCKS for second order solution and irfs%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

shocks;
var epsA; stderr sigma_s;
var epsAtrend; stderr 0.1*sigma_s;
var epsG; stderr sigma_s;
var epsMC; stderr sigma_s ;
var epsMPS; stderr sigma_s ;
var epsMRSS; stderr sigma_s ;
var epsRPS; stderr sigma_s ;
var epsIS; stderr sigma_s;
end;



check;

stoch_simul(order=1,irf=40) Y C I H Hd W R Q Rn PIE RK spread N Omega;

stoch_simul(order=2,pruning, irf=0) Y C I H Hd W R Q Rn PIE RK spread N Omega;

